import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_TAGS = 'GET_TAGS',
    ATTACH_CAR_TAG = 'ATTACH_CAR_TAG',
    ATTACH_USER_TAG = 'ATTACH_USER_TAG',
    ATTACH_AREA_TAG = 'ATTACH_AREA_TAG',
    ATTACH_ACCOUNT_TAG = 'ATTACH_ACCOUNT_TAG',
    ATTACH_TRACE_TAG = 'ATTACH_TRACE_TAG',
    UPDATE_TRACE_TAG = 'UPDATE_TRACE_TAG',
    CAR_TAG_PROPOSE = 'CAR_TAG_PROPOSE',
    EVOLVE_TAG = 'EVOLVE_TAG',
    UPDATE_CAR_TAG = 'UPDATE_CAR_TAG',
    UPDATE_USER_TAG = 'UPDATE_USER_TAG',
    UPDATE_AREA_TAG = 'UPDATE_AREA_TAG',
    UPDATE_ACCOUNT_TAG = 'UPDATE_ACCOUNT_TAG',

    GET_CAR_TAG_LIST = 'GET_CAR_TAG_LIST',
    GET_TRACE_TAG_LIST = 'GET_TRACE_TAG_LIST',
}

export const TAG_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.ATTACH_CAR_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'car/tag/add',
    },
    [REQUESTS.GET_CAR_TAG_LIST]: {
        api: 'car/tag/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_TRACE_TAG_LIST]: {
        api: 'trace/tag/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.ATTACH_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
        cgiObj: {
            report_tag_info: null,
        },
    },
    [REQUESTS.CAR_TAG_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'car/tags/propositions/propose',
        cgiObj: {
            object_id: null,
            comment: null,
        },
    },
    [REQUESTS.EVOLVE_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/evolve',
        cgiObj: {
            tag_id: null,
            evolution_mode: null,
        },
    },
    [REQUESTS.UPDATE_CAR_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'car/tag/update',
    },
    [REQUESTS.UPDATE_AREA_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'area_tags/update',
    },
    [REQUESTS.UPDATE_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/update',
    },
    [REQUESTS.ATTACH_AREA_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'area_tags/add',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.ATTACH_ACCOUNT_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'account/tag/add',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.ATTACH_TRACE_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'trace/tag/add',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.UPDATE_TRACE_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'trace/tag/update',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.UPDATE_ACCOUNT_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'account/tag/update',
    },
};
