import { Dict } from '../../../types';
import { controlType, ISchemaItem } from '../FormConstructor/types';

export const MARKER = 'photo_support_by_client';

export const WINDOW_DESCRIPTION = `Окно для прикрепления фото к тегу.\n`
    + `Можно загрузить файл с компьютера и/или указать ссылку на файл, \n`
    + `после чего прикрепить все файлы к тегу`;

export const CHAT_LINKS_FORM_SCHEMA: Dict<ISchemaItem> = {
    chat_link: {
        type: controlType.string,
        display_name: 'Ссылка на чат',
        description: 'Из чата загрузятся все фотографии, которые будут найдены в сообщениях',
    },
};

export const PHOTOS_LINKS_FORM_SCHEMA: Dict<ISchemaItem> = {
    link_chat_array: {
        type: controlType.array_types,
        display_name: 'Ссылки на фото из чата',
        array_type: {
            type: controlType.string,
            display_name: 'Ссылка',
        },
    },
    link_core_array: {
        type: controlType.array_types,
        display_name: 'Ссылки на фото',
        array_type: {
            type: controlType.string,
            display_name: 'Ссылка',
        },
    },
};

export enum UploadMethod {
    FROM_DISK = 'from_disk',
    FROM_PHOTO_LINK = 'from_photo_link',
    FROM_CHAT_LINK = 'from_chat_link',
}

export const UPLOAD_METHOD_DISPLAY_NAME = {
    [UploadMethod.FROM_DISK]: 'Файлы с диска',
    [UploadMethod.FROM_PHOTO_LINK]: 'Файлы по ссылке на фото',
    [UploadMethod.FROM_CHAT_LINK]: 'Файлы по ссылке на чат',
};
