import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    REGISTER_TAG_PHOTO = 'REGISTER_TAG_PHOTO',
    UPLOAD_TAG_PHOTO = 'UPLOAD_TAG_PHOTO',
    GET_CHAT_HISTORY = 'GET_CHAT_HISTORY',
}

export const TAG_PHOTO_REQUESTS: IComponentRequest = {
    [REQUESTS.REGISTER_TAG_PHOTO]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/photos/register',
    },
    [REQUESTS.UPLOAD_TAG_PHOTO]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/photos/upload',
        cgiObj: {
            object_id: null,
            photo_id: null,
        },
    },
    [REQUESTS.GET_CHAT_HISTORY]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chat/history',
        cgiObj: {
            chat_id: null,
            user_id: null,
        },
    },
};
