import * as React from 'react';

import { ENVIRONMENT } from '../../../../types';
import { truncateString } from '../../../utils/utils';
import styles from './index.css';

interface IEnvWidgetBadgeProps {
    env: ENVIRONMENT;
}

const envMaxLength = 9;

const colorEnvWidget = (env: ENVIRONMENT) => {
    switch (env) {
    case ENVIRONMENT.ADMIN:
        return '#00800080';
    case ENVIRONMENT.TESTING:
        return '#304fff90';
    case ENVIRONMENT.PRESTABLE:
        return '#62a8e4';
    default:
        return '#8a75d1';
    }
};

export const EnvWidgetBadge = (props: IEnvWidgetBadgeProps) => {
    const { env } = props;

    return <span className={styles.env} style={{ backgroundColor: colorEnvWidget(env) }}>
        {props.env ? `${truncateString(env, envMaxLength)}` : ''}
    </span>;
};
