import moment from 'moment';
import * as React from 'react';

import { Dict } from '../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../constants';
import { Link } from '../../ui/Link';
import { VISITED_TYPES } from '../Content/types';
import { EnvWidgetBadge } from './EnvWidgetBadge';
import * as style from './index.css';

const UNFINISHED_SESSION_TIME = 'now';

function createSessionTitle(data): string {
    const number = data?.[1]?.[0]?.response?.number;
    const device_diff = data?.[1]?.[0]?.response.device_diff || {};

    const date = moment(device_diff.start?.timestamp * ONE_SECOND).format('DD.MM.YY');
    const startTime = moment(device_diff.start?.timestamp * ONE_SECOND).format('HH:MM');
    const finishTime = device_diff.finish?.timestamp
        ? moment(device_diff.finish?.timestamp * ONE_SECOND).format('HH:MM')
        : device_diff.current ? UNFINISHED_SESSION_TIME : '';
    const carNumber = number || '';

    return date && startTime && finishTime && carNumber
        ? `${carNumber} | ${date} (${startTime}-${finishTime})`
        : data[0];
}

function getWidgetTitle(data: any[], type?: string): string {
    if (type === VISITED_TYPES.session) {
        return createSessionTitle(data);
    }

    if (type === VISITED_TYPES.clients) {
        return data?.[1]?.[0]?.response?.email || data?.[0];
    }

    if (type === VISITED_TYPES.cars) {
        if (data?.[1]?.[0]?.response?.number && data?.[1]?.[0]?.response?.model) {
            return `${data?.[1]?.[0]?.response?.number} | ${data?.[1]?.[0]?.response?.model}`;
        }
    }

    return data[0] || '';
}

export const Top10Widget = React.memo((props: { withEnv?: boolean; data: any[]; label: string; type?: string }) => {
    return <div className={style.top10}>
        <h4>{props.label}</h4>
        <ul>
            {
                props.data.map((i: [string, Dict<any>], index) => {
                    const env = i[1] && i[1][0] && i[1][0].env || EMPTY_DATA;
                    let href = `#${i[0]}`;
                    if (props.type) {
                        href = `#/${props.type}/${i[0]}`;
                    }

                    const title = getWidgetTitle(i, props.type);

                    return <li key={index}>
                        {props.withEnv && <EnvWidgetBadge env={env}/>}
                        <Link className={style.link} href={href}>{title}</Link>
                    </li>;
                })
            }
        </ul>
    </div>;
});
