import { Dict } from '../../../../types';
import { Request2 } from '../../../utils/request';
import { WIDTH_MAP_CONTROL } from '../../Map2/helpers/widthMapControl';
import { drawPoly } from '../../MiniMap/utils';
import { drawPolygonControl } from '../drawPolygonControl';
import { REQUESTS, TRACKS_REQUESTS } from '../request';

declare let ymaps;
const legendKey = 'legend';

export const drawClientPolygonControl = (
    props: {
        sessionId: string;
        polyConfig: {stroke: number; opacity_coeff: number};
        polygonsCollection: any;
        map: any;
        title?: string;
        polyControlPairData?: Dict<any>;
    },
    _this?: any,
) => {
    const {
        sessionId,
        polyConfig,
        polygonsCollection,
        map,
        title = 'Полигоны  (как клиент)',
        polyControlPairData,
    } = props;
    const request = new Request2({ requestConfigs: TRACKS_REQUESTS });
    const clientPolygonControl = new ymaps.control.Button({
        data: { content: title },
        options: {
            maxWidth: WIDTH_MAP_CONTROL,
        },
    });

    if (polyControlPairData && _this) {
        _this.polygonsControl = drawPolygonControl({
            polyFilters: polyControlPairData.polyFilters,
            BlockRules: polyControlPairData.BlockRules,
            map,
            polygonsCollection,
            polyControlPair: clientPolygonControl,
        });
    }

    clientPolygonControl.events
        .add('select', () => {
            polygonsCollection.removeAll();
            clientPolygonControl.disable();

            if (_this?.polygonsControl) {
                const iterator = _this.polygonsControl.getIterator();
                let obj;
                while ((obj = iterator.getNext()) !== iterator.STOP_ITERATION) {
                    obj.deselect();
                }
            }

            request.exec(REQUESTS.GET_CURRENT_POLYGONS, {
                queryParams: {
                    session_id: sessionId,
                },
            })
                .then((response) => {
                    const keys = Object.keys(response)
                        .filter((key) => key !== legendKey);
                    keys.forEach((key) => {
                        if (response?.[key]) {
                            drawPoly({
                                polygons: response[key],
                                polygonsCollection,
                                polyConfig,
                            });
                        }
                    });
                    clientPolygonControl.enable();
                });
        })
        .add('deselect', () => {
            polygonsCollection.removeAll();
        });

    map && map.controls.add(clientPolygonControl, { float: 'right' });

    return clientPolygonControl;
};
