declare let ymaps;

export const drawFilterTraceControl = (map, listBoxControl, objectManager) => {
    const listBoxItems = [
        { content: 'Стоянки', selected: true },
        { content: 'Превышения', selected: true },
        { content: 'Остальное', selected: false },
    ].map(function (data) {
        return new ymaps.control.ListBoxItem({
            data: data,
            state: {
                selected: data.selected,
            },
        });
    });

    listBoxControl = new ymaps.control.ListBox({
        data: {
            content: 'Фильтр',
            title: 'Фильтр',
        },
        items: listBoxItems,
        state: {
            expanded: true,
            filters: listBoxItems.reduce(function (filters, filter) {
                filters[filter.data.get('content')] = filter.isSelected();

                return filters;
            }, {}),
        },
    });

    listBoxControl.events.add(['select', 'deselect'], (e: any) => {
        const listBoxItem = e.get('target');
        const filters = ymaps.util.extend({}, listBoxControl.state.get('filters'));
        filters[listBoxItem.data.get('content')] = listBoxItem.isSelected();
        listBoxControl.state.set('filters', filters);
    });

    const getFilterFunction = (categories: any) => {
        return (obj: any) => {
            const hintContent = obj.properties.hintContent;

            return categories[hintContent];
        };
    };

    const filterMonitor = new ymaps.Monitor(listBoxControl.state);
    filterMonitor.add('filters', (filters: any) => {
        objectManager.setFilter(getFilterFunction(filters));
    });

    objectManager.setFilter(getFilterFunction({
        'Стоянки': true,
        'Превышения': true,
        'Остальное': false,
    }));

    map.controls.add(listBoxControl, { float: 'right' });

    return listBoxControl;
};
