import { WIDTH_MAP_CONTROL } from '../../Map2/helpers/widthMapControl';

declare let ymaps;

export const drawShowAllStatusesControl = (map, showAllControl, status, search, manageStatus) => {
    showAllControl = new ymaps.control.Button({
        data: { content: 'Показать всё' },
        state: {
            selected: status == '',
        },
        options: {
            maxWidth: WIDTH_MAP_CONTROL,
        },
    });

    showAllControl.events
        .add('select', () => {
            manageStatus('');
        })
        .add('deselect', () => {
            manageStatus(null);
        });

    map.controls.add(showAllControl, { float: 'right' });

    return showAllControl;
};
