import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../constants';
import { getRawSetting2 } from '../../utils/getRawSetting';
import { IStore } from '../App/store';
import { polyFiltersKey } from '../InterfaceAdminConfig/adminConfigKeys';
import { TrackMap } from './component';

const POLY_FILTERS_KEY = `${GVARS_INTERFACE_ADMIN_PREFIX}.${polyFiltersKey}`;
const POLY_CONFIG_KEY = 'interface_admin.polyConfig';

export const mapStateToProps = (store: IStore ) => {
    return {
        polyConfig: getRawSetting2(store, POLY_CONFIG_KEY),
        polyFilters: getRawSetting2(store, POLY_FILTERS_KEY),
        BlockRules: store?.AdminUser?.blockRules,
    };
};

export function mapDispatchToProps() {
    return {};
}

export default connect(mapStateToProps, mapDispatchToProps)(TrackMap);
