import { IComponentRequest } from '../../utils/request';

export enum REQUESTS {
    GET_SESSION = 'GET_SESSION',
    GET_TRACK = 'GET_TRACK',
    GET_TRACE = 'GET_TRACE',
    GET_POLYGONS = 'GET_POLYGONS',
    GET_CARS = 'GET_CARS',
    GET_CURRENT_POLYGONS = 'GET_CURRENT_POLYGONS',
    GET_CAR_TAGS = 'GET_CAR_TAGS',
    GET_TELEMATICS_STATE = 'GET_TELEMATICS_STATE',
    GET_TELEMATICS_HISTORY = 'GET_TELEMATICS_HISTORY',
    GET_CAR_INFO = 'GET_CAR_INFO',
    GET_TRACE_TAG_LIST = 'GET_TRACE_TAG_LIST',
}

export const TRACKS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_TRACE_TAG_LIST]: {
        api: 'trace/tag/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_SESSION]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            session_id: null,
        },
    },
    [REQUESTS.GET_TRACK]: {
        api: 'track/analyzer',
        cgiObj: {
            session: null,
            car_id: null,
            user_id: null,

            status: null,

            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_TRACE]: {
        api: 'track/trace',
        cgiObj: {
            ride: null,
        },
    },
    [REQUESTS.GET_POLYGONS]: {
        api: 'areas/info',
    },
    [REQUESTS.GET_CAR_TAGS]: {
        api: 'car/tag/list',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
    },
    [REQUESTS.GET_CURRENT_POLYGONS]: {
        api: 'areas/drop/info',
        cgiObj: {
            session_id: null,
            use_styles: '1',
        },
    },
    [REQUESTS.GET_TELEMATICS_STATE]: {
        api: 'car/telematics/state',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_TELEMATICS_HISTORY]: {
        api: 'car/telematics/history',
        cgiObj: {
            imei: null,
        },
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
};
