import * as React from 'react';

import { LSSettingItems } from '../../../types';
import { Window } from '../../ui/FullModal';
import { getCookie } from '../../utils/cookie';
import LS from '../../utils/localStorage/localStorage';
import { ytLogs } from '../../utils/sendLogs';
import { EVENT_TYPES } from '../../utils/sendLogs/eventTypes/eventTypes';
import { IAdminUser } from '../Content';
import UserSettings from '../Settings/Saas/UserSettings';
import UserMenu from '../UserMenu';
import * as style from './index.css';
import { UNKNOWN_USER } from './unknownUser';

export class User extends React.Component<IAdminUser, any> {
    state = {
        isActive: false,
        isOnline: true,
        userInfoModalOpen: false,
    };
    ls = new LS();
    log = ytLogs.getInstance();

    onClick() {
        this.setState({
            isActive: !this.state.isActive,
        });
    }

    componentDidMount(): void {
        this.init();

    }

    openUserInfoModal(userInfoModalOpen) {
        this.setState({ userInfoModalOpen });
    }

    componentDidUpdate(prevProps: Readonly<IAdminUser>, prevState: Readonly<any>, snapshot?: any) {
        if (prevProps.AdminUser.userId !== this.props.AdminUser.userId) {
            this.debugSettingsInfo();
        }
    }

    debugSettingsInfo() {
        //@ts-ignore
        this.props.AdminUser?.yandex_login && window?.navigator?.webkitTemporaryStorage?.queryUsageAndQuota(
            (used, remaining) => {
                const data = {
                    event_type: EVENT_TYPES.CUSTOM_LOG,
                    meta: {
                        space: {
                            used,
                            remaining,
                        },
                        yl: getCookie('yandex_login'),
                        type: 'DEBUG_INFO_SPACE',
                    },
                };
                this.log.send({ data });
            }, (err) => {
                console.warn(err);
            });
    }

    init() {
        window.addEventListener('offline', () => {
            this.setState({
                isOnline: false,
            });
        });

        window.addEventListener('online', (e) => {
            this.setState({
                isOnline: true,
            });
        });
    }

    toggleSideBar(value: boolean) {
        this.setState({
            isActive: value,
        });
    }

    render() {
        return <div>
            <div className={style.component} onClick={this.onClick.bind(this)}>
                <Avatar yandex_login={this.props.AdminUser.yandex_login || undefined} isOnline={this.state.isOnline}/>
                <div className={style.text_data}>
                    <div className={style.username}>{this.props.AdminUser.yandex_login || UNKNOWN_USER}</div>
                    <div className={style.env}>{this.ls.get(LSSettingItems.env)} | {process.env.VERSION}</div>
                </div>
            </div>
            <UserMenu active={this.state.isActive}
                      toggleSideBar={this.toggleSideBar.bind(this)}
                      openUserInfoModal={this.openUserInfoModal.bind(this, true)}/>

            {this.state.userInfoModalOpen
                ? <Window onClose={this.openUserInfoModal.bind(this, false)}
                          title={'Пользовательские настройки'}>
                    <UserSettings/>
                </Window>
                : null
            }
        </div>;
    }
}

const Avatar = React.memo((props: { yandex_login?: string; isOnline: boolean }) => {
    const url = `https://center.yandex-team.ru/api/v1/user/${props.yandex_login}/avatar/40.jpg`;
    const customStyle = props.yandex_login ? { backgroundImage: `url(${url})` } : {};

    return <div className={style.avatar} style={customStyle}>
        <div className={`${style.notify} ${props.isOnline ? style.online : style.offline}`}/>
    </div>;
});
