import React from 'react';

import { CHAT_ROLES_TAG } from '../../../constants';
import Checkbox from '../../../ui/Checkbox';
import { Request2 } from '../../../utils/request';
import { IStore } from '../../App/store';
import { REQUESTS, UI_REQUESTS as requestConfigs } from './request';

interface IRolesForQueueProps extends IStore {
    onError: (err: any) => void;
    getRoles: () => void;
}

export class RolesForQueue extends React.Component<IRolesForQueueProps> {
    state = {
        chatRoles: [],
        checkBoxes: [],
        checkBoxesDisabled: [],
    };

    request = new Request2({
        requestConfigs,
    });

    componentDidMount(): void {
        this.prepare(this.props);
    }

    prepare(props) {
        const roles: any = props.AdminUser?.rolesRaw || [];
        const chatRoles = roles.filter((role) => {
            return role?.role_description?.role_groupping_tags?.toUpperCase?.()
                ?.includes?.(CHAT_ROLES_TAG);
        });
        this.setState({
            chatRoles,
            checkBoxes: chatRoles.map(role => role.user_role.active === '1'),
            checkBoxesDisabled: chatRoles.map(role => false),
        });
    }

    onChange(role, index, value) {
        this.props.onError(null);
        this.request.exec(REQUESTS.CHANGE_STATUS, {
            queryParams: {
                status: value ? 'activate' : 'deactivate',
                user_id: role.user_role.user_id,
                role_id: role.user_role.role_id,
            },
        })
            .then(() => {
                this.props.getRoles();
            })
            .catch(err => {
                this.props.onError(err);
            });
    }

    render() {
        return <div>
            <h3>Вибираем очереди и начинаем помогать клиентам.</h3>
            <h4>Хорошо початиться!</h4>
            <table>
                <tbody>
                    {
                        this.state.chatRoles.map((role: any, index: number) => {
                            return <tr key={index}>
                                <td><Checkbox checked={this.state.checkBoxes[index]}
                                              onChange={this.onChange.bind(this, role, index)}
                                              disabled={this.state.checkBoxesDisabled[index]}/></td>
                                <td>{role
                            && role.role_description
                            && role.role_description.role_description}</td>
                            </tr>;
                        })
                    }
                </tbody>
            </table>
        </div>;
    }
}
