import { connect } from 'react-redux';

import { LANGUAGES } from '../../../types';
import { getStatusTags } from '../../reducers/chatReducer/getters';
import { setCurrentLang } from '../../reducers/localizationReducer';
import { IStore } from '../App/store';
import { UserMenu } from './component';

export const mapStateToProps = (store: any) => {
    return {
        AdminUser: store.AdminUser,
        Lang: store.Lang,
        status_tags: getStatusTags(store),
    };
};

export function mapDispatchToProps(dispatch: any): IDispatchToProps {
    return {
        setCurrentLang: (lang: LANGUAGES) => {
            dispatch(setCurrentLang(lang, null));
        },
    };
}

export interface IDispatchToProps {
    setCurrentLang: (lang: LANGUAGES) => void;
}

export default connect<IStore, IDispatchToProps, any>(mapStateToProps, mapDispatchToProps)(UserMenu);
