import React from 'react';

import { GetSessions, IGetSessionsPropsExport } from '../../../decorators/GetSessions';
import { EMPTY_DATA } from '../../constants';
import { SessionHistoryInfoHandler } from '../../models/session';
import Select, { IOptionInfo } from '../../ui/Select';
import { isObjectEqual } from '../../utils/isObjectEqual';

interface IUserSessionViewProps extends IGetSessionsPropsExport {
    user_id: string;
    onSelect: (sessionId: string) => void;
}

@GetSessions({ numdoc: 50 })
export class UserSessionSelect extends React.Component<IUserSessionViewProps> {
    componentDidMount() {
        this.props.user_id && this.props.getSessions?.({ user_id: this.props.user_id });
    }

    componentDidUpdate(prevProps: Readonly<IUserSessionViewProps>, prevState) {
        if (this.props.user_id && this.props.user_id !== prevProps.user_id) {
            this.props.getSessions?.({ user_id: this.props.user_id });
        }

        if (!isObjectEqual(this.props.sessionsData, prevProps.sessionsData)) {
            this.onSelect('');
        }
    }

    onSelect(index) {
        const sessionId = index !== ''
            ? SessionHistoryInfoHandler.getSessionId.call(this.props.sessionsData, index)
            : null;
        this.props.onSelect(sessionId ?? null);
    }

    render() {
        const { sessionOptions } = this.props;
        const options: IOptionInfo[] = [{
            value: -1,
            text: EMPTY_DATA,
            description: 'Не связано с поездкой',
        }];

        sessionOptions && options.push(...sessionOptions.slice());

        return <Select options={options}
                       onSelect={this.onSelect.bind(this)}
                       placeholder={'Сессии пользователя'}
                       isLoading={this.props.sessionIsLoading}/>;
    }
}
