import produce from 'immer';
import React from 'react';

import Select from '../../ui/Select';
import { Request2 } from '../../utils/request';
import { SimpleError } from '../SimpleError';
import Spin from '../Spin';
import * as style from './index.css';
import { CLIENTS_REQUESTS, REQUESTS } from './request';

interface IUsersProps {

}

export class Users extends React.Component<IUsersProps> {
    request = new Request2({ requestConfigs: CLIENTS_REQUESTS });
    state = {
        error: null,
        data: {} as any,
        isLoading: false,
        selectedTag: '',
    };

    componentDidMount(): void {
        this.getAllTags();
    }

    getAllTags() {
        this.setState(produce(this.state, draft => {
            draft.isLoading = true;
        }), () => {
            this.request.exec(REQUESTS.GET_TAG_DESCRIPTIONS)
                .then(response => {
                    this.setState(produce(this.state, draft => {
                        draft.isLoading = false;
                        draft.error = null;
                        draft.data = response;
                    }));
                })
                .catch(error => {
                    this.setState(produce(this.state, draft => {
                        draft.isLoading = false;
                        draft.error = error;
                    }));
                });
        });
    }

    selectTagItem(item) {
        this.setState(produce(this.state, draft => {
            draft.selectedTag = item;
        }));
    }

    render() {
        const options = this.state.data
            && this.state.data.records
            && this.state.data.records.map(item => {
                return { text: item.display_name | item.name, value: item.name, description: item.comment };
            });

        return <div className={style.component}>
            <h4>Список пользователей</h4>
            {
                this.state.isLoading
                    ? <Spin/>
                    : this.state.error
                        ? <SimpleError error={this.state.error}/>
                        : <div>
                            <div className={style.controls}>
                                <Select placeholder={'tag'}
                                        multiSelect
                                        options={options}
                                        onSelect={this.selectTagItem.bind(this)}/>
                            </div>
                        </div>
            }
        </div>;
    }
}
