import * as React from 'react';

import { ExcelUploader, IJSONData } from '../ExcelUploader';
import * as style from './index.css';
import { UploadingInsuranceModal } from './UploadingInsuranceModal/component';
import { UploadingVinModal } from './UploadingVinModal/component';

const ODD_PAGES = ['свод', 'Лист1', 'Лист4'];

interface IVinSimViewState {
    fileDataVin: IJSONData[] | null;
    isVinUploadConfirmOpen: boolean;

    fileDataInsurance: IJSONData[] | null;
    fileDataInsuranceError: Error | null;
    isInsuranceUploadConfirmOpen: boolean;
}

export default class VinSimView extends React.Component<IVinSimViewState, {}> {
    state: IVinSimViewState = {
        fileDataVin: null,
        isVinUploadConfirmOpen: false,

        fileDataInsurance: null,
        fileDataInsuranceError: null,
        isInsuranceUploadConfirmOpen: false,
    };

    JSONVinLoadHandler(JSONData: IJSONData[]) {
        JSONData && this.setState({
            fileDataVin: JSONData,
            isVinUploadConfirmOpen: true,
        });
    }

    closeVinUploadConfirm() {
        this.setState({ isVinUploadConfirmOpen: false });
    }

    JSONInsuranceLoadHandler(JSONData: IJSONData[]) {
        let fileDataInsuranceError: Error | null = null;
        const fileDataInsurance = JSONData?.filter((sheet) => {
            if (!ODD_PAGES.includes(sheet.sheetName)) {
                return true;
            }

            fileDataInsuranceError = new Error(`Файл содержит один из лишних листов ${ODD_PAGES.join(', ')}`);

            return false;

        }) ?? [];

        this.setState({
            fileDataInsurance,
            fileDataInsuranceError,
            isInsuranceUploadConfirmOpen: true,
        });
    }

    closeInsuranceUploadConfirm() {
        this.setState({
            fileDataInsurance: null,
            fileDataInsuranceError: null,
            isInsuranceUploadConfirmOpen: false,
        });
    }

    render() {
        const {
            isVinUploadConfirmOpen, fileDataVin,
            isInsuranceUploadConfirmOpen, fileDataInsurance, fileDataInsuranceError,
        } = this.state;

        return <div className={style.vin_sim_view}>
            <div>
                <h3>Vin:</h3>
                <ExcelUploader JSONHandler={this.JSONVinLoadHandler.bind(this)}/>
            </div>
            <div>
                <h3>Страховка:</h3>
                <ExcelUploader JSONHandler={this.JSONInsuranceLoadHandler.bind(this)}/>
            </div>
            {isVinUploadConfirmOpen
                ? <UploadingVinModal fileData={fileDataVin ?? []}
                                     onClose={this.closeVinUploadConfirm.bind(this)}/>
                : null}
            {isInsuranceUploadConfirmOpen
                ? <UploadingInsuranceModal fileData={fileDataInsurance ?? []}
                                           fileError={fileDataInsuranceError}
                                           onClose={this.closeInsuranceUploadConfirm.bind(this)}/>
                : null}
        </div>;
    }
}
