import React from 'react';

import { Window } from '../../../ui/FullModal';
import { NoInformation } from '../../../ui/NoInformation';
import style from '../style.css';
import { IMapFilters, IMapFiltersItem } from '../types';

interface ICarVariantsModalProps {
    data: IMapFilters | undefined;
    allowedVariants: string[];
    onClose: () => void;
}

export const CarVariantsModal = React.memo((props: ICarVariantsModalProps) => {
    const { allowedVariants, data } = props;

    return <Window onClose={props.onClose.bind(null)} title={'На чём поедем?'}>
        {allowedVariants?.length
            ? allowedVariants.map((el, ind) => {
                const item = data?.[el] || {} as IMapFiltersItem;
                const imgSrc: string = item.icon || '';

                return <div key={ind} className={style.car_variant_item}>
                    <img src={imgSrc} alt={'car'} className={style.car_img}/>
                    <div>
                        <div className={style.car_variant_name}>{item.name}</div>
                        <div className={style.car_variant_desc}>{item.description}</div>
                    </div>
                </div>;
            })
            : <NoInformation/>
        }
    </Window>;
});
