export interface IVoyageResponse {
    filters: IFilter[];
    filters_caption: string;
    items: IVoyageItem[];
    map_filters: IMapFilters;
}

export interface IVoyageItem {
    behaviour_constructors: string[];
    builders: string[];
    color: string;
    description_full: string;
    description_short: string;
    features: any[];
    filters_refs: string[];
    id: string;
    list_filters: string[];
    name: string;
    photo: string;
    pin_icon: string;
    pin_name: string;
    position: IPosition;
    tags: any[];
}

export interface IMapFilters {
    [key: string]: IMapFiltersItem;
}

export interface IMapFiltersItem {
    name: string;
    icon: string;
    description: string;
    filters: string[];
}

interface IPosition {
    lat: number;
    lon: number;
}

interface IFilter {
    box: {
        min_lat: number;
        max_lat: number;
        min_lon: number;
        max_lon: number;
    };
    default_selected: boolean;
    id: string;
    picker_name: string;
    selected_name: string;
}
