export enum WEBPHONE_STATUS {
    registered = 'registered',
    connected = 'connected',
    connecting = 'connecting',
    addstream = 'addstream',
    notRegistered = 'notRegistered',
    registrationFailed = 'registrationFailed',
    registrationFailedDuringCall = 'registrationFailedDuringCall',
}

export enum CALL_STATUS {
    unhold = 'unhold',
    hold = 'hold',
    accepted = 'accepted',
    peerconnection = 'peerconnection',
    connecting = 'connecting',
    progress = 'progress',
    failed = 'failed',
    ended = 'ended',
}

export const webphoneStatusDescriptions = {
    registered: 'Готов к работе',
    connected: 'Соединен',
    connecting: 'Соединение...',
    addstream: 'addstream',
    progress: 'В процессе',
    failed: 'Завершен с ошибкой',
    ended: 'Завершен',
    notRegistered: 'Не зарегистрирован',
    registrationFailed: 'Ошибка регистрации',
    registrationFailedDuringCall: 'Пожалуйста перезарегистрируйтесь',
};

export const callStatusDescriptions = {
    unhold: 'Снят с удержания',
    hold: 'На удержании',
    accepted: 'Звонок принят',
    peerconnection: 'peerconnection',
    connecting: 'Соединение...',
    progress: 'Дозвон...',
    failed: 'Звонок не принят',
    ended: 'Звонок завершен',
    // customCallStatusDescription
    busy: 'Абонент занят',
    endedByUser: 'Звонок завершен клиентом',
};

export enum CallSourceOptions {
    DEFAULT = 'default_call_source',
    CUSTOM = 'custom_call_source',
}

export interface ICallRecipient {
    user_id?: string;
    phone: string;
}

export type TIdInCall = string | undefined;

export interface IGetCallIdProps {
    callRecipient: ICallRecipient;
    callSource: CallSourceOptions;
    chatTagId: TIdInCall;
}
