import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../constants';
import { getRawSetting2 } from '../../utils/getRawSetting';
import { IStore } from '../App/store';
import { additionalWebphoneNumber,callSourceKeys } from '../InterfaceAdminConfig/adminConfigKeys';
import { Webphone } from './component';

const callSourceKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${callSourceKeys}`;
const additionalWebphoneNumberKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${additionalWebphoneNumber}`;

export const mapStateToProps = (store: IStore) => {
    return {
        yandexLogin: store.AdminUser?.yandex_login,
        webphoneStore: store.Webphone,
        callSourceKeys: getRawSetting2(store, callSourceKey),
        additionalWebphoneNumber: getRawSetting2(store, additionalWebphoneNumberKey),
    };
};

export const mapDispatchToProps = (dispatch) => {
    return {
        dispatch,
    };
};

export default connect(mapStateToProps, mapDispatchToProps)(Webphone);
