import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_CALL_ID = 'GET_CALL_ID',
    SET_CLASSIFICATION = 'SET_CLASSIFICATION',
    DROP_PERFORM = 'DROP_PERFORM',
    CALL_UPDATE = 'CALL_UPDATE'
}

export const WEBPHONE_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_CALL_ID]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'webphone/call',
        cgiObj: {
            user_id: null,
            phone: null,
            tag_id: null,
            category_id: null,
        },
    },
    [REQUESTS.SET_CLASSIFICATION]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/add',
    },
    [REQUESTS.DROP_PERFORM]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'user/tag/perform/finish',
    },
    [REQUESTS.CALL_UPDATE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'webphone/call/update',
    },
};
