import * as React from 'react';

import { UIStatusTypes } from '../../../../ui';
import { Input } from '../../../../ui/Input';
import Call2 from '../buttons/Call2';
import WebphoneLogsDisplay from '../buttons/WebphoneLogsDisplay';
import WebphoneStatus from '../WebphoneStatus';
import styles from './index.css';

export const CallNotClientPanel = () => {
    const [phoneNumber, setPhoneNumber] = React.useState('');
    const [isValidPhoneNumber, validatePhoneNumber] = React.useState(true);
    const phoneNumberRegex = /^\+[0-9]+$/g;

    const setValidPhoneNumber = (value) => {
        setPhoneNumber(value);
        validatePhoneNumber(phoneNumberRegex.test(value));
    };

    return <div className={styles.callNotClientPanelContainer}>
        <WebphoneStatus/>
        <Input status={isValidPhoneNumber ? null : { type: UIStatusTypes.negative }}
               placeholder={'Телефон не клиента в формате +7...'}
               value={phoneNumber}
               onChange={setValidPhoneNumber}
               dontShowPlaceholderIfFocused/>
        <Call2 disabled={!phoneNumber.length || !isValidPhoneNumber}
               client={phoneNumber}/>
        <WebphoneLogsDisplay/>
    </div>;
};
