import * as React from 'react';
import { useSelector } from 'react-redux';

import { getCallMetaInfo, TCallMetaInfo } from '../../../../../reducers/webphoneReducer';
import { Link } from '../../../../../ui/Link';
import styles from './index.css';

export const CallMetaInfo = () => {
    const callMetaInfo: TCallMetaInfo | null = useSelector(getCallMetaInfo);
    const isClientCall = callMetaInfo?.name && callMetaInfo?.id;
    const clientCallStyles = isClientCall
        ? styles.callMetaInfoSecondary
        : `${styles.callMetaInfoPrimary} ${styles.callNotAClient}`;

    return <div className={styles.callMetaInfo}>
        {isClientCall
            ? <Link href={`#/clients/${callMetaInfo?.id}/info`}
                    target={'_blank'}
                    className={styles.callMetaInfoPrimary}>
                {callMetaInfo?.name}
            </Link>
            : null
        }
        <span className={`${styles.callMetaInfoPhoneNumber} ${clientCallStyles}`}>
            {callMetaInfo?.phoneNumber}
        </span>
    </div>;
};
