import moment from 'moment';
import * as React from 'react';

import { ONE_SECOND } from '../../../../../../constants';

export const CallTimer = () => {
    /* store call duration as milliseconds for formatting, increment at each second */
    const [milliseconds, setMilliseconds] = React.useState(0);

    React.useEffect(() => {
        const interval = setInterval(() => {
            setMilliseconds(seconds => seconds + ONE_SECOND);
        }, ONE_SECOND);

        return () => clearInterval(interval);
    }, [milliseconds]);

    return <span>{moment.utc(milliseconds).format('HH:mm:ss')}</span>;
};
