import * as React from 'react';
import { useSelector } from 'react-redux';

import PhoneIcon from '../../../../../../svg-components/phone.component.svg';
import { getCallStatus, getCallStatusDescription } from '../../../../../reducers/webphoneReducer';
import { CALL_STATUS } from '../../../helpers/webphoneTypes';
import CallTimer from './CallTimer';
import styles from './index.css';

export const CallStatus = () => {
    const callStatusDescription = useSelector(getCallStatusDescription);
    const callStatus = useSelector(getCallStatus);
    const isActiveCall = callStatus === CALL_STATUS.hold || callStatus === CALL_STATUS.accepted;
    const isProgressCall = callStatus === CALL_STATUS.progress;

    return <div className={styles.callStatus}>
        <PhoneIcon className={styles.callStatusIcon}/>
        {isActiveCall
            ? <CallTimer/>
            : isProgressCall
                ? <>
                    <span>{callStatusDescription}</span>
                    <CallTimer/>
                </>
                : <span>{callStatusDescription}</span>
        }
    </div>;
};
