import * as React from 'react';
import { batch, useDispatch, useSelector } from 'react-redux';

import {
    hasWebphoneAcceptedCall,
    hasWebphoneActiveCall, setCallMetaInfo,
    setCallStatus,
} from '../../../../reducers/webphoneReducer';
import { Cross } from '../../../../ui/Cross';
import EndCall from '../buttons/EndCall';
import HoldCall from '../buttons/HoldCall';
import MuteCall from '../buttons/MuteCall';
import WebphoneLogsDisplay from '../buttons/WebphoneLogsDisplay';
import CallMetaInfo from './CallMetaInfo';
import CallStatus from './CallStatus';
import styles from './index.css';

export const CurrentCallPanel = () => {
    const hasActiveCall = useSelector(hasWebphoneActiveCall);
    const hasAcceptedCall = useSelector(hasWebphoneAcceptedCall);
    const dispatch = useDispatch();

    return <div className={styles.currentCallPanelContainer}>
        <CallMetaInfo/>
        <CallStatus/>
        <div className={styles.callActionsSection}>
            <WebphoneLogsDisplay/>
            {hasAcceptedCall && <HoldCall/>}
            {hasAcceptedCall && <MuteCall/>}
        </div>
        {hasActiveCall && <EndCall/>}
        {!hasActiveCall && <Cross onClick={() => {
            batch(() => {
                dispatch(setCallMetaInfo(null));
                dispatch(setCallStatus(null));
            });
        }}/>}
    </div>;
};
