import * as React from 'react';

import { Window } from '../../../../ui/FullModal';
import styles from './index.css';

interface IEnableMicrophoneModalProps {
    onClose: () => void;
}

export const EnableMicrophoneModal = (props: IEnableMicrophoneModalProps) => {
    const { onClose } = props;

    return <Window className={styles.modal}
                   onClose={onClose}
                   title={'Кажется у вас не разрешено использование микрофона'}>
        <figure>
            <figcaption className={styles.gifCaption}>
                Для начала работы с звонками, необходимо разрешить использование микрофона в браузере.
            </figcaption>
            <figcaption className={styles.gifCaption}>В Яндекс.Браузере это можно сделать, как на гифке:</figcaption>
            <img className={styles.image}
                 height={500}
                 src="https://carsharing.s3.yandex.net/admin/static/webphone/allow_microphone_special.gif"
                 alt="Разрешение для браузера пользоваться микрофоном"/>
        </figure>
    </Window>;
};
