import * as React from 'react';
import { useSelector } from 'react-redux';

import { isWebphoneNotRegistered } from '../../../../reducers/webphoneReducer';
import RegisterWebphone from '../buttons/RegisterWebphone';
import WebphoneLogsDisplay from '../buttons/WebphoneLogsDisplay';
import WebphoneStatus from '../WebphoneStatus';
import styles from './index.css';

export const RegisterPanel = () => {
    const isNotRegistered = useSelector(isWebphoneNotRegistered);

    return <div className={styles.registerPanelContainer}>
        <WebphoneStatus/>
        {isNotRegistered && <RegisterWebphone/>}
        <WebphoneLogsDisplay/>
    </div>;
};
