import * as React from 'react';
import { useSelector } from 'react-redux';

import {
    hasWebphoneCall,
    isWebphoneNotRegistered,
} from '../../../../reducers/webphoneReducer';
import CallNotClientPanel from '../CallNotClientPanel';
import CurrentCallPanel from '../CurrentCallPanel';
import RegisterPanel from '../RegisterPanel';
import styles from './index.css';

export const WebphonePanel = () => {
    const hasCall = useSelector(hasWebphoneCall);
    const isRegistered = !useSelector(isWebphoneNotRegistered);

    return <div className={styles.webphonePanel}>
        {!isRegistered && !hasCall
            ? <RegisterPanel/>
            : hasCall
                ? <CurrentCallPanel/>
                : <CallNotClientPanel/>}
    </div>;
};
