import * as React from 'react';

import { Button } from '../../../../ui/Button';
import Checkbox from '../../../../ui/Checkbox';
import { Window } from '../../../../ui/FullModal';
import styles from './index.css';

interface IWelcomePopupProps {
    neverShowOption?: (shouldNeverShow :boolean) => void;
    title: string;
    onClose: () => void;
}

export const WelcomePopup = (props: React.PropsWithChildren<IWelcomePopupProps>) => {
    const { neverShowOption, onClose, title, children } = props;
    const [shouldNeverShow, setNeverShow] = React.useState(false);

    React.useEffect(() => {
        neverShowOption?.(shouldNeverShow);
    }, [shouldNeverShow]);

    return <Window className={styles.welcomePopup}
                   onClose={onClose}
                   title={title}>
        {children}
        <span className={styles.controlsContainer}>
            {neverShowOption
                ? <>
                    <Checkbox checked={shouldNeverShow}
                              onChange={setNeverShow.bind(null, !shouldNeverShow)}/>
                    <label className={styles.neverShowOptionLabel}>
                        <u>Все понятно, больше не показывать</u>
                    </label>
                </>
                : null
            }
            <Button className={styles.okButton}
                    onClick={onClose}>
                    Хорошо
            </Button>
        </span>
    </Window>;
};
