import * as React from 'react';

import styles from './index.css';

export const WelcomePopupWebphone = React.memo(() => {
    return <div className={styles.welcomeWebphone}>
        <p>Скоро из админки Драйва можно будет звонить 🙌</p>
        <p>Из основного:</p>
        <ol>
            <li>
                {/* specifying height in img for correct modal overflow */}
                <figure>
                    <img height={35}
                         src="https://carsharing.s3.yandex.net/admin/static/webphone/1_register.png"
                         alt="Указание на кнопку регистрации"/>
                    <figcaption>перед началом работы необходимо зарегистрироваться</figcaption>
                </figure>
            </li>
            <li>
                <figure>
                    <img height={150}
                         src="https://carsharing.s3.yandex.net/admin/static/webphone/1_allow_microphone.png"
                         alt="Разрешение для браузера пользоваться микрофоном"/>
                    <figcaption>перед первым звонком браузер попросит разрешить использовать микрофон</figcaption>
                </figure>
            </li>
            <li>
                <figure>
                    <img height={100}
                         src="https://carsharing.s3.yandex.net/admin/static/webphone/1_call_client.png"
                         alt="Кнопка 'Позвонить' клиенту"/>
                    <figcaption>можно позвонить клиенту прямо из сайдбара (кнопка появится после регистрации в
                        телефонии)
                    </figcaption>
                </figure>
            </li>
            <li>
                <figure>
                    <img height={35}
                         src="https://carsharing.s3.yandex.net/admin/static/webphone/2_call_client.png"
                         alt="Форма для звонка неклиента"/>
                    <figcaption>не клиенту можно позвонить из нижней панели</figcaption>
                </figure>
            </li>
            <li>
                <figure>
                    <img height={30}
                         src="https://carsharing.s3.yandex.net/admin/static/webphone/1_logs.png"
                         alt="Кнопка 'скачать логи звонка'"/>
                    <figcaption>к сообщениям о неполадках просьба прикладывать логи звонка</figcaption>
                </figure>
            </li>
        </ol>
        <p>⚡ ⚠️ ОГРАНИЧЕНИЯ ТЕСТОВОГО РЕЖИМА:</p>
        <ul>
            <li>Активный звонок завершится при переходе из вкладки с диспетчерской в другие разделы админки. <strong>Не
                забывайте об этом, так как пока нет функционала, чтобы это отследить и предупредить!</strong> Можно
                открыть админку в другой вкладке и свободно передвигаться там.
            </li>
            <li>
                Активный звонок завершится при закрытие или рефреше вкладки с диспетчерской (чтобы случайно не закрыть
                вкладку, здесь мы переспросим вас).
            </li>
        </ul>
        <p>❗❗ Пожалуйста сообщайте нам о недостатках и багах (сразу вместе с логами звонка)</p>
    </div>;
});
