import * as React from 'react';

import HistoryIcon from '../../../../../../svg-components/history.component.svg';
import MicrophoneIcon from '../../../../../../svg-components/microphone.component.svg';
import MicrophoneMutedIcon from '../../../../../../svg-components/microphone_muted.component.svg';
import PauseIcon from '../../../../../../svg-components/pause.component.svg';
import PhoneIcon from '../../../../../../svg-components/phone.component.svg';
import PlayIcon from '../../../../../../svg-components/play.component.svg';
import { Button, ButtonTypes } from '../../../../../ui/Button';
import styles from './index.css';

interface IButtonWithIconProps {
    colorType?: ButtonTypes;
    icon: string;
    text?: string;
    onClick?: () => unknown;
    iconClassName?: string;
    buttonClassName?: string;
    disabled?: boolean;
    basic?: boolean;
}

export const ButtonWithIcon = (props: IButtonWithIconProps) => {
    const { colorType, icon, text, basic, onClick, iconClassName, buttonClassName, disabled } = props;

    return <Button colorType={colorType}
                   onClick={onClick}
                   className={buttonClassName}
                   disabled={disabled}
                   basic={basic}>
        <span className={styles.webphoneButton}>
            {generateIcon(icon, `${styles.webphoneButton_icon} ${iconClassName ?? ''}`)}
            {text?.length
                ? <span className={styles.webphoneButton_text}>
                    {text}
                </span>
                : null
            }
        </span>
    </Button>;
};

const generateIcon = (type, className) => {
    switch(type) {
    case 'phone':
        return <PhoneIcon className={className}/>;
    case 'play':
        return <PlayIcon className={className}/>;
    case 'pause':
        return <PauseIcon className={className}/>;
    case 'history':
        return <HistoryIcon className={className}/>;
    case 'microphoneMuted':
        return <MicrophoneMutedIcon className={className}/>;
    case 'microphone':
        return <MicrophoneIcon className={className}/>;
    default:
        return null;
    }
};
