import * as React from 'react';
import { useDispatch } from 'react-redux';

import { setCallMetaInfo, TCallMetaInfo } from '../../../../../../reducers/webphoneReducer';
import { ButtonTypes } from '../../../../../../ui/Button';
import { ICallRecipient } from '../../../../helpers/webphoneTypes';
import ButtonWithIcon from '../../ButtonWithIcon';
import mainStyles from '../../index.css';
import styles from './index.css';

interface ICallHandlerProps {
    disabled?: boolean;
    buttonClassName?: string;
    userId: string | undefined;
    client: string;
    userName: string | undefined;
    setCallRecipient: (callRecipient: ICallRecipient | null) => void;
}

export const CallHandler = (props: ICallHandlerProps) => {
    const { disabled, buttonClassName, userId, client, userName, setCallRecipient } = props;
    const dispatch = useDispatch();

    const setCallData = () => {
        const callRecipient: ICallRecipient = {
            user_id: userId ? encodeURIComponent(userId) : userId,
            phone: encodeURIComponent(client),
        };

        setCallRecipient(callRecipient);

        let metaInfo: TCallMetaInfo = {
            phoneNumber: client,
        };

        if (userId && userName) {
            metaInfo = {
                ...metaInfo,
                id: userId,
                name: userName,
            };
        }

        dispatch(setCallMetaInfo(metaInfo));
    };

    return <ButtonWithIcon onClick={() => {
        setCallData();
    }}
                           disabled={disabled}
                           buttonClassName={`${mainStyles.button} ${buttonClassName ?? ''}`}
                           iconClassName={disabled ? styles.callButtonIconDisabled : ''}
                           colorType={ButtonTypes.positive}
                           icon={'phone'}
                           text={userId ? 'Позвонить' : 'Позвонить не клиенту'}/>;
};
