import * as React from 'react';

import { ButtonTypes } from '../../../../../../ui/Button';
import ButtonWithChoicesPopup from '../../../../../../ui/ButtonWithPopup/ButtonWithChoicesPopup';
import { generateuuid4, isTest } from '../../../../../../utils/utils';
import { CallSourceOptions } from '../../../../helpers/webphoneTypes';

interface ICallSourceProps {
    disabled?: boolean;
    onSelect: (value: CallSourceOptions) => void;
    callSource: CallSourceOptions;
}

const HASH_LENGTH = 5;

export const CallSource = (props: ICallSourceProps) => {
    const { disabled, onSelect, callSource } = props;
    const options = [
        {
            value: CallSourceOptions.DEFAULT,
            label: 'Позвонить на номер',
            isDefault: true,
        },
        {
            value: CallSourceOptions.CUSTOM,
            label: 'Позвонить от лица клиента',
        },
    ];

    const id = React.useMemo(() => `call-source-${isTest() ? '1' : generateuuid4().substr(0, HASH_LENGTH)}`, []);

    return <ButtonWithChoicesPopup initialSelectedValue={callSource}
                                   disabled={disabled}
                                   onSelect={onSelect}
                                   id={id}
                                   options={options}
                                   markIfNonDefaultChoice
                                   displayArrowIcon
                                   colorType={ButtonTypes.positive}/>;
};
