import * as React from 'react';

import UserInfo, { UserInfoHandler } from '../../../../../models/user';
import { CallSourceOptions, ICallRecipient } from '../../../helpers/webphoneTypes';
import CallHandler from './CallHandler';
import styles from './CallHandler/index.css';
import CallSource from './CallSource';

interface ICall2Props {
    client: string;
    userInfo?: UserInfo;
    disabled?: boolean;
    buttonClassName?: string;
    chatTagId?: string;
    containerClassName?: string;
}

export const Call2 = (props: ICall2Props & {callEnded; setCallMetaInfo; callFromWebphone}) => {
    const {
        client,
        userInfo,
        disabled,
        buttonClassName,
        containerClassName,
        chatTagId,
        callEnded,
        callFromWebphone,
    } = props;
    const [callSource, setCallSource] = React.useState<CallSourceOptions>(CallSourceOptions.DEFAULT);
    const [callRecipient, setCallRecipient] = React.useState<ICallRecipient | null>(null);

    React.useEffect(() => {
        setCallSource(CallSourceOptions.DEFAULT);
        setCallRecipient(null);
    }, [callEnded]);

    React.useEffect(() => {
        if (callRecipient) {
            callFromWebphone(
                client,
                {
                    callRecipient,
                    chatTagId,
                    callSource,
                },
            );
        }
    }, [callRecipient]);

    return <>
        <div className={`${styles.callButtonContainer} ${containerClassName ?? ''}`}>
            <CallHandler setCallRecipient={setCallRecipient}
                         client={client}
                         disabled={disabled}
                         buttonClassName={buttonClassName}
                         userId={UserInfoHandler.getId.call(userInfo)}
                         userName={UserInfoHandler.getPrintNameWithoutUserName.call(userInfo)}/>
            <CallSource callSource={callSource}
                        onSelect={setCallSource}
                        disabled={disabled}/>
        </div>
    </>;
};
