import { connect } from 'react-redux';

import {
    callFromWebphone,
    hasCallEnded,
    setCallMetaInfo,
    TCallMetaInfo,
} from '../../../../../reducers/webphoneReducer';
import { IStore } from '../../../../App/store';
import { IGetCallIdProps } from '../../../helpers/webphoneTypes';
import { Call2 } from './component';

export const mapStateToProps = (store: IStore) => {
    return {
        callEnded: hasCallEnded(store),
    };
};

export const mapDispatchToProps = (dispatch) => {
    return {
        setCallMetaInfo: (metaInfo: TCallMetaInfo | null) => dispatch(setCallMetaInfo(metaInfo)),
        callFromWebphone: (client: string, callInfo: IGetCallIdProps) => dispatch(callFromWebphone(client, callInfo)),
    };
};

export default connect(mapStateToProps, mapDispatchToProps)(Call2);
