import * as React from 'react';

import { Button, ButtonTypes } from '../../../../../ui/Button';
import { Cross } from '../../../../../ui/Cross';
import { Input } from '../../../../../ui/Input';
import styles from './index.css';

interface IForwardCallProps {

}

export const ForwardCall = (props: IForwardCallProps) => {
    let {} = props;
    const [isForwardPopupOpen, setForwardPopup] = React.useState(false);

    return <div className={styles.forwardCallContainer}>
        {isForwardPopupOpen && (
            <ForwardCallPopup onClose={setForwardPopup.bind(null, false)}/>
        )}
        <Button onClick={() => {setForwardPopup(prev => !prev);}}
                className={isForwardPopupOpen ? styles.forwardCallButtonPopupOpen : ''}
                colorType={ButtonTypes.warning}
                basic>
            Переадресовать звонок
        </Button>
    </div>;
};

interface IForwardCallPopup {
    onClose: () => void;
}

const ForwardCallPopup = (props: IForwardCallPopup) => {
    const { onClose } = props;
    const [callDestination, inputCallDestination] = React.useState('');

    return <div className={styles.forwardCallPopup}>
        <Cross className={styles.forwardCallPopupCross}
               onClick={onClose}/>
        <Input autoFocus
               focusedClassName={styles.forwardCallPopupInputFocused}
               className={styles.forwardCallPopupInput}
               placeholder={'[sip:username | номер телефона]'}
               value={callDestination}
               onChange={inputCallDestination}/>
        <Button className={styles.forwardCallPopupButton}
                colorType={ButtonTypes.warning}>
            Переадресовать
        </Button>
    </div>;
};
