import * as React from 'react';
import { useDispatch } from 'react-redux';

import { holdCall } from '../../../../../reducers/webphoneReducer';
import { ButtonTypes } from '../../../../../ui/Button';
import ButtonWithIcon from '../ButtonWithIcon';
import buttonStyles from '../index.css';
import styles from './index.css';

export const HoldCall = () => {
    const dispatch = useDispatch();
    const [isHoldActive, setHold] = React.useState(false);

    return <ButtonWithIcon onClick={() => {
        dispatch(holdCall(isHoldActive));
        setHold(prev => !prev);
    }}
                           iconClassName={styles.holdIcon}
                           buttonClassName={`${buttonStyles.button} ${styles.holdButton}`}
                           colorType={isHoldActive ? ButtonTypes.positive : ButtonTypes.warning}
                           icon={isHoldActive ? 'play' : 'pause'}
                           text={isHoldActive ? 'Вернуться' : 'Удержать'}/>;
};
