import moment from 'moment';
import * as React from 'react';

import { Window } from '../../../../../../ui/FullModal';
import UserRequests from '../../../../../Clients/UserRequests2';
import { RequestUserType } from '../../../../../Clients/UserRequests2/component';
import { FILTER_TYPES } from '../../../../../Clients/UserRequests2/FilterRequests/component';

interface ILastCallsModalProps {
    userId: string;
    onClose: () => void;
}

export const LastCallsModal = (props: ILastCallsModalProps) => {
    const { userId, onClose } = props;

    return <Window title={'История исходящих звонков'}
                   onClose={onClose}>
        <UserRequests user_type={RequestUserType.user}
                      id={userId}
                      tags={{}}
                      selectedFilters={[FILTER_TYPES.WEBPHONE]}
                      since={moment().subtract(1, 'week').valueOf()}
                      until={moment().valueOf()}/>
    </Window>;
};
