import * as React from 'react';

import { ButtonTypes } from '../../../../../ui/Button';
import { ButtonWithIcon } from '../ButtonWithIcon/component';
import styles from './index.css';
import { LastCallsModal } from './LastCallsModal/component';

interface ILastCallsProps {
    userId: string;
}

export const LastCalls = (props: ILastCallsProps) => {
    const { userId } = props;
    const [isModalOpen, openModal] = React.useState();

    return <>
        {isModalOpen && <LastCallsModal userId={userId} onClose={openModal.bind(null, false)}/>}
        <ButtonWithIcon onClick={openModal.bind(null, true)}
                        buttonClassName={styles.lastCallButton}
                        iconClassName={styles.lastCallIcon}
                        colorType={ButtonTypes.positive}
                        basic
                        text={'История исходящих'}
                        icon={'history'}/>
    </>;
};
