import * as React from 'react';
import { useDispatch } from 'react-redux';

import { muteCall } from '../../../../../reducers/webphoneReducer';
import { ButtonTypes } from '../../../../../ui/Button';
import ButtonWithIcon from '../ButtonWithIcon';
import buttonStyles from '../index.css';
import styles from './index.css';

export const MuteCall = () => {
    const dispatch = useDispatch();
    const [isMuteActive, setMute] = React.useState(false);

    return <ButtonWithIcon onClick={() => {
        dispatch(muteCall(isMuteActive));
        setMute(prev => !prev);
    }}
                           iconClassName={styles.microphoneIcon}
                           buttonClassName={buttonStyles.button}
                           colorType={isMuteActive ? ButtonTypes.positive : ButtonTypes.warning}
                           icon={isMuteActive ? 'microphoneMuted' : 'microphone'}
                           text={isMuteActive ? 'Вкл. микрофон' : 'Выкл. микрофон'}/>;
};
