import * as React from 'react';

import { Button } from '../../../../../ui/Button';
import { FormatDateInString } from '../../../../../ui/FormatDate';
import { download } from '../../../../../utils/utils';
import WebphoneLogs from '../../../helpers/webphoneLogs';
import styles from '../index.css';

export const WebphoneLogsDisplay = () => {
    const [areLogsPreparing, setLogsPreparing] = React.useState(false);
    const onLogsClick = async () => {
        setLogsPreparing(true);
        const webphoneLogsHelper = new WebphoneLogs();
        const logs = await webphoneLogsHelper.getLogsForDownload();
        download(logs, `webphone-${FormatDateInString({ value: Date.now() })}`, 'text/plain', () => {
            setLogsPreparing(false);
        });
    };

    return <>
        <Button className={styles.button}
                isLoading={areLogsPreparing}
                onClick={onLogsClick}
                basic>
            Скачать лог телефонии
        </Button>
    </>;
};
