import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Provider } from 'react-redux';
import configureMockStore from 'redux-mock-store';
import thunk from 'redux-thunk';

import { IWebphoneReducerState } from '../../../../reducers/webphoneReducer';
import { WEBPHONE_STATUS } from '../../helpers/webphoneTypes';
import Call2 from './Call2';
import EndCall from './EndCall';
import ForwardCall from './ForwardCall';
import HoldCall from './HoldCall';
import styles from './index.story.css';
import LastCalls from './LastCalls';
import MuteCall from './MuteCall';
import WebphoneLogsDisplay from './WebphoneLogsDisplay';

const defaultStoreObject: IWebphoneReducerState = {
    status: WEBPHONE_STATUS.registered,
    callStatus: null,
    callMetaInfo: null,
    call: null,
    action: null,
    hold: null,
    mute: null,
    customCallStatusDescription: null,
};

const store = configureMockStore<{ Webphone: IWebphoneReducerState }>([thunk])({
    Webphone: defaultStoreObject,
});

storiesOf('Webphone buttons', module)
    .add('Call button', () => {
        return <Provider store={store}>
            <div className={styles.call}>
                <Call2 client={''}/>
                <Call2 userInfo={{ name: 'Test', id: '1' }}
                       client={''}/>
            </div>
        </Provider>;
    })
    .add('Forward call popup', () => {
        return <Provider store={store}>
            <div className={styles.forwardCall}>
                <ForwardCall/>
            </div>
        </Provider>;
    })
    .add('Call logs button', () => {
        return <Provider store={store}>
            <div>
                <WebphoneLogsDisplay/>
            </div>
        </Provider>;
    })
    .add('End call button', () => {
        return <Provider store={store}>
            <div>
                <EndCall/>
            </div>
        </Provider>;
    })
    .add('Hold call button', () => {
        return <Provider store={store}>
            <div>
                <HoldCall/>
            </div>
        </Provider>;
    })
    .add('Mute call button', () => {
        return <Provider store={store}>
            <div>
                <MuteCall/>
            </div>
        </Provider>;
    })
    .add('Last calls button', () => {
        return <LastCalls userId={'d'}/>;
    });
