import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Provider } from 'react-redux';
import configureMockStore from 'redux-mock-store';
import thunk from 'redux-thunk';

import { IWebphoneReducerState } from '../../../reducers/webphoneReducer';
import { CALL_STATUS, WEBPHONE_STATUS } from '../helpers/webphoneTypes';
import styles from './panels.story.css';
import WebphonePanel from './WebphonePanel';

const defaultStoreObject: IWebphoneReducerState = {
    status: WEBPHONE_STATUS.registered,
    callStatus: null,
    callMetaInfo: null,
    call: null,
    action: null,
    hold: null,
    mute: null,
    customCallStatusDescription: null,
};

const Component = (store) => {
    return <Provider store={store}>
        <div className={styles.panelContainer}>
            <WebphonePanel/>
        </div>
    </Provider>;
};

storiesOf('Webphone panels', module)
    .add('Webphone status: Not registered (RegisterPanel)', () => {
        const store = configureMockStore<{ Webphone: IWebphoneReducerState }>([thunk])({
            Webphone: {
                ...defaultStoreObject,
                status: WEBPHONE_STATUS.notRegistered,
            },
        });

        return Component(store);
    })
    .add('Webphone status: Connecting (RegisterPanel)', () => {
        const store = configureMockStore<{ Webphone: IWebphoneReducerState }>([thunk])({
            Webphone: {
                ...defaultStoreObject,
                status: WEBPHONE_STATUS.connecting,
            },
        });

        return Component(store);
    })
    .add('Webphone status: Registered (CallNotClientPanel)', () => {
        const store = configureMockStore<{ Webphone: IWebphoneReducerState }>([thunk])({
            Webphone: {
                ...defaultStoreObject,
                status: WEBPHONE_STATUS.registered,
            },
        });

        return Component(store);
    })
    .add('Webphone status: Call a client (CurrentCallPanel)', () => {
        const store = configureMockStore<{ Webphone: IWebphoneReducerState }>([thunk])({
            Webphone: {
                ...defaultStoreObject,
                status: WEBPHONE_STATUS.registered,
                callStatus: CALL_STATUS.accepted,
                callMetaInfo: {
                    name: 'Тестовый Тест Тестович',
                    id: '1',
                    phoneNumber: '+1234567890',
                },
            },
        });

        return Component(store);
    })
    .add('Webphone status: Call not a client (CurrentCallPanel)', () => {
        const store = configureMockStore<{ Webphone: IWebphoneReducerState }>([thunk])({
            Webphone: {
                ...defaultStoreObject,
                status: WEBPHONE_STATUS.registered,
                callStatus: CALL_STATUS.accepted,
                callMetaInfo: {
                    phoneNumber: '+1234567890',
                },
            },
        });

        return Component(store);
    })
    .add('Webphone status: Ended call (CurrentCallPanel)', () => {
        const store = configureMockStore<{ Webphone: IWebphoneReducerState }>([thunk])({
            Webphone: {
                ...defaultStoreObject,
                status: WEBPHONE_STATUS.registered,
                callStatus: CALL_STATUS.ended,
                callMetaInfo: {
                    name: 'Тестовый Тест Тестович',
                    id: '1',
                    phoneNumber: '+1234567890',
                },
            },
        });

        return Component(store);
    });
