/*eslint-disable no-magic-numbers*/
import React from 'react';

import { GeoPoints, ICities } from '../../types';

export const EMPTY_DATA = '—';
export const UTC_OFFSET = 3;
export const HALF_SECOND = 500;
export const ONE_SECOND = 1000;
export const DIGIT_THOUSAND = 1000;
export const ONE_MINUTE = ONE_SECOND * 60;
export const ONE_HOUR = ONE_MINUTE * 60;
export const ONE_DAY = ONE_HOUR * 24;
export const ONE_MONTH = ONE_DAY * 30;
export const ONE_HOUR_IN_MINUTES = 60;
export const ONE_WEEK_IN_DAYS = 7;
export const LOCALIZATION_RESOURCE_PREFIX = 'admin_settings_';
export const DAYS_LABEL = ['Пн', 'Вт', 'Ср', 'Чт', 'Пт', 'Сб', 'Вс'];

export const ONE_KILOMETER = 1000;

export const ACTUALITY_GVARS_DELTA = 42;

export const ROBOT_FRONTEND = 'robot-frontend';
export const STAFF_ONLY = 'staff_only';

export const COINS_PER_RUBLE = 100;
export const COINS_LENGTH = 2;
export const ONE_HUNDRED_PERCENT = 100;
export const ONE_HUNDRED_ITEMS = 100;

export const GVARS_INTERFACE_ADMIN_PREFIX = 'interface_admin';
export const GVARS_SCOOTER_PREFIX = 'scooter';
export const SESSION_TAB_ID = 's2';
export const OLD_SESSION_TAB_ID = 'sessions';

export const CLIENT_ERRORS_CODE_START = 4;

export const TIMERS = {
    SELECTED_CHAT: 1000,
    CHATS: 5000,
    CHATS_LIST: 2000,
    OTHER_CHATS: 4000,
    CHECK_SUPPORT_ALERTS: 2000,
    UPDATE_SELECTED: 1000,
    OUTGOING_CHATS: 10000,
    CLOSE_CALL_NOTIFY: 10000,
};

export const GEO_POINTS: GeoPoints = {
    PITER: {
        LABEL: {
            short: 'spb',
            area_tags: 'spb_area',
            normal: 'Питер',
        },
        OPTIONS: {
            center: [30.315868, 59.939095],
            zoom: 10,
        },
    },
    MOSCOW: {
        LABEL: {
            short: 'msk',
            area_tags: 'msc_area',
            normal: 'Москва',
        },
        OPTIONS: {
            center: [37.648295, 55.768326],
            zoom: 10,
        },
    },
    KAZAN: {
        LABEL: {
            short: 'kzn',
            area_tags: 'kazan_area',
            normal: 'Казань',
        },
        OPTIONS: {
            center: [49.108795, 55.796289],
            zoom: 10,
        },
    },
    SOCHI: {
        LABEL: {
            short: 'Сочи',
            area_tags: 'sochi_area',
            normal: 'Сочи',
        },
        OPTIONS: {
            center: [39.723062, 43.585525],
            zoom: 8,
        },
    },
    SKLAD: {
        LABEL: {
            short: 'skld',
            area_tags: '',
            normal: 'Рыбинское вдхр.',
        },
        OPTIONS: {
            center: [38.418950, 58.317912],
            zoom: 8,
        },
    },
    KM_47: {
        LABEL: {
            short: '47км',
            area_tags: 'msc_area',
            normal: '47км',
        },
        OPTIONS: {
            center: [37.441175, 55.652083],
            zoom: 16,
        },
    },
};

export const SHORT_GEO_POINTS = {
    MOSCOW: GEO_POINTS.MOSCOW,
    PITER: GEO_POINTS.PITER,
    SOCHI: GEO_POINTS.SOCHI,
    KAZAN: GEO_POINTS.KAZAN,
};

export const HOST = 'carsharing.yandex.net';

/*map*/

export const CAR_UPDATE_INTERVAL = ONE_MINUTE / 2;

export const MAGIC_ZOOM = {
    5: 0.01,
    6: 0.1,
    7: 0.5,
    8: 1.2,
    9: 2,
    10: 5,
    11: 6,
    12: 20,
    13: 40,
    14: 80,
    15: 160,
    16: 200,
    17: 400,
    18: 800,
    19: 5000,
};

export const CAR_COLORS = {

    /*statusColors*/
    available: 0x388E3C,
    cleaning: 0x808000,
    fueling: 0x333333,
    old_state_parkin: 0xffca28,
    old_state_reserv: 0x8e24aa,
    old_state_riding: 0x3d5afe,
    old_state_accept: 0xec407a,
    fake: 0xec407a,
    service: 0xd46900,
    new: 0xec407a,
    total: 0xec407a,
    transformation: 0xec407a,
    drive_team_access: 0xec407a,

    /*idleColors*/
    h1: 0x1c9500,
    h2: 0x3f51b5,
    h3: 0xff9800,
    h6: 0xff007f,
    h9: 0x795548,
    h24: 0x9e9e9e,
    h48: 0x333333,
    h72: 0x333333,
    h72_more: 0x333333,

    /*kffColors*/
    'less_0.1': 0xffeb3b,
    'less_0.5': 0xff9800,
    less_1: 0xf44336,
    less_2: 0xe91e63,
    more_2: 0xe91e1e,
};

export const CAR_COLORS_RGB = {
    default: 'fed700',
    available: '388E3C',
    cleaning: '808000',
    fueling: '333333',
    old_state_parkin: 'ffca28',
    old_state_reserv: '8e24aa',
    old_state_riding: '3d5afe',
    old_state_accept: 'ec407a',
    fake: 'ec407a',
    service: 'd46900',
    new: 'ec407a',
    total: 'ec407a',
    transformation: 'ec407a',
    drive_team_access: 'ec407a',
};

export const idleRanges = [[0, 1], [1, 2], [2, 3], [3, 6], [6, 9], [9, 24], [24, 48], [48, 72]];

export const surgeRanges = [0, 0.1, 0.5, 1, 2];

export const ALPHABET_LOWER_CASE = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'];

export const polyFilters = {
    all: {
        name: 'Весь автопарк',
        tags: [],
    },
    main: {
        name: 'Основной автопарк',
        tags: ['allow_drop_car', 'deny_drop_car', 'allow_riding', 'impoundment_lot'],
    },
    cargo: {
        name: 'Грузовой автопарк',
        tags: ['deny_drop_car', 'allow_riding', 'impoundment_lot'],
        include: ['cargo'],
    },
    shuttle: {
        name: 'Шатлы',
        tags: ['deny_drop_car', 'allow_riding', 'shuttle_allow_drop_car', 'shuttle_deny_drop_car', 'impoundment_lot'],
    },
    electric: {
        name: 'Электромобили',
        tags: ['deny_drop_car', 'allow_riding', 'electric_car_allow_drop_car', 'electric_car_deny_drop_car',
            'impoundment_lot'],
    },
    exclusive: {
        name: 'Эксклюзивное авто',
        tags: ['deny_drop_car', 'allow_riding', 'pony_car_allow_drop_car', 'pony_car_deny_drop_car', 'impoundment_lot'],
    },
    /* porsche_911: {
         name: 'Porsche 911 / Panamera',
         tags: ['deny_drop_car', 'allow_riding', 'porsche_car_allow_drop_car', 'impoundment_lot']
     },*/
    corridor: {
        name: 'Междугородние поездки',
        tags: ['allow_riding', 'allow_riding_corridor_msk-kzn', 'allow_riding_corridor_msk-spb', 'cargo_allow_drop_car', 'shuttle_allow_drop_car', 'cargo_deny_drop_car', 'deny_drop_car', 'shuttle_deny_drop_car'],
    },
    surge: {
        name: 'Полигоны ценообразования',
        tags: ['surge'],
        include: ['surge', 'offer'],
    },
};

export const CITIES: ICities = {
    msc_area: {
        name: 'Москва',
        short_name: 'МСК',
        short_name_en: 'msk',
    },
    spb_area: {
        name: 'Санкт-Петербург',
        short_name2: 'Питер',
        short_name: 'СПБ',
        short_name_en: 'spb',
    },
    kazan_area: {
        name: 'Казань',
        short_name: 'КЗН',
        short_name_en: 'kzn',
    },
    sochi_area: {
        name: 'Сочи',
        short_name: 'СОЧИ',
        short_name_en: 'sochi',
    },
};

export const CUSTOM_TAGS = {
    SIMPLE_CAR_TAG: 'simple_car_tag',
    CAR_SERVICE_TAG: 'car_service_tag',
    PUT_TAGS_OFF: 'put_tags_off',
    EXPRESS_CLEANING: 'express_cleaning',
    SIMPLE_USER_TAG: 'simple_user_tag',
    BONUS_TAG: 'bonus_tag',
    FIXED_SUM_TAG: 'fixed_sum_tag',
    PUSH_TAG: 'user_push',
    USER_LANDING: 'user_landing',
    OPERATION_TAG: 'operation_tag',
    MULTI_USER_TAG: 'multi_user_tag',
    AREA_USER_INFO: 'area_user_info',
    USER_PROBLEM_TAG: 'user_problem_tag',
};

export const USER_INFO_CSV_ROW = 'Имя;Фамилия;Отчество;Серия;Номер;Дата выдачи;Кем выдан;Дата рождения;Место рождения;Место жительства;Номер;Категория;Cтаж с;Когда выданы;Действительны до;Номер телефона;email\n';

export const CLASS_FURGON = 'class_furgon';
export const SHUTTLE = 'msk_shuttle_custom_drop_area';
export const PONY = 'msk_pony_custom_drop_area';
export const ELECTRIC = 'msk_electric_car_custom_drop_area';
export const MODEL_LEAF = 'model_leaf';
export const PORSCHE_911 = 'model_porsche_911';
export const PANAMERA = 'model_porsche_panamera';

export const LONGTERM_MARK = 'long_term';
export const LONGTERM_FEED_TAG = 'support_out_longterm';
export const DEDICATED_FLEET_TAG = 'dedicated_fleet';
export const MARKET_FLEET_TAG = 'b2b_market';

export const defaultAntitraits = 'ReportShowAllModels';
export const defaultTraits = 'ReportIMEI,ReportVIN';
export const mileageSensor = 'mileage';

export const DEFAULT_COORDINATES = {
    LAT: 58.461954,
    LON: 38.163288,
};

export const RESERVATION_FEATURES = 'tag_reservation_features';
export const FREE_DELEGATION = 'free_delegation_tag';

export const MINIMUM_AGE = 21;
export const MINIMUM_EXPERIENCE = 2;

export const getActuality = (delta?: number) => {
    return Math.floor(new Date().getTime() / ONE_SECOND - (delta ?? ACTUALITY_GVARS_DELTA));
};

// Chats
export const CHAT_ROLES_TAG = 'CHATS';
export const CALL_ROLES_TAG = 'CALLS';
export const DUTY_ROLES_TAG = 'DUTY';

export enum DUTY_STATE {
    COMMON = 'duty',
    BREAK = 'duty_break',
    SUPPOSEDLY_AFK = 'duty_supposedly_afk',
    ENDED = 'duty_end',
}

export function GetFilterTagRulesDesc(classname) {
    return <ul className={classname}>
        <li>&|? — соответственно, тег скрытый или не скрытый другими тегами с более высоким приоритетом</li>
        <li>+|- — соответственно должен быть или нет (это как сейчас и есть). + по умолчанию</li>
        <li>#|' — соответственно, тег не выполняется или выполняется (наличие performer)</li>
        <li>*|, — соответственно, и | или</li>
    </ul>;
}
