import React, { useEffect } from 'react';

import { isValidJSONString } from '../utils/isValidJSONString';
import { API_PREFIXES, Request2 } from '../utils/request';
import { useRequestHandler } from './useRequestHandler';

const GET_GLOBAL_SETTINGS = 'GET_GLOBAL_SETTINGS';
const DAM_PREFIX = 'service_app.settings.exp_damages.model';
const requestConfigs = {
    [GET_GLOBAL_SETTINGS]: {
        api: 'settings/info',
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        cgiObj: {
            prefix: null,
            actuality: null,
        },
    },
};

export const useDamagesConfig = () => {
    const request = new Request2({ requestConfigs });

    const requestOptions = React.useMemo(() => {
        return {
            requestName: GET_GLOBAL_SETTINGS,
            requestOptions: {
                queryParams: {
                    prefix: DAM_PREFIX,
                },
            },
        };
    }, []);

    const responseHandler = (response) => {
        const value = response?.settings?.[0]?.setting_value;
        if (isValidJSONString(value)) {
            return JSON.parse(value);
        }

        return {};
    };

    const [isLoading, response, error, makeResponse] = useRequestHandler(request, requestOptions, responseHandler);

    useEffect(() => {
        makeResponse();

        return () => {
            request.abort();
        };
    }, []);

    return [isLoading, response, error];
};
