import * as React from 'react';

import { Dict } from '../../types';
import { Request2 } from '../utils/request';

interface IRequestOptions {
    requestName: string;
    requestOptions: Dict<unknown>;
}

export function useRequestHandler<T>(
    request: Request2,
    options: IRequestOptions,
    responseHandler?: (_res) => T | null,
): [boolean, T | null, Error | null, () => void] {
    const [isLoading, setLoading] = React.useState(false);
    const [response, setResponse] = React.useState<T | null>(null);
    const [error, setError] = React.useState<Error | null>(null);
    const [requestShouldFire, fireRequest] = React.useState<boolean>(false);

    React.useEffect(() => {
        if (options && requestShouldFire) {
            setLoading(true);
            const fetchData = async () => {
                setError(null);

                try {
                    const _response = await request.exec(options.requestName, { ...options.requestOptions });
                    if (responseHandler) {
                        setResponse(responseHandler(_response));
                    } else {
                        setResponse(_response);
                    }
                } catch (e) {
                    setError(e);
                }
            };

            fetchData().then(() => {
                setLoading(false);
                fireRequest(false);
            });
        }

        return () => {
            request.abort();
        };
    }, [requestShouldFire]);

    return [isLoading, response, error, () => {fireRequest(true);}];
}
