import React, { useEffect } from 'react';

import { Request2 } from '../utils/request';
import { useRequestHandler } from './useRequestHandler';

const GET_GLOBAL_SETTINGS = 'GET_TAGS';
const requestConfigs = {
    [GET_GLOBAL_SETTINGS]: {
        api: 'tag/description/list',
    },
};

export const useTagsData = () => {
    const request = new Request2({ requestConfigs });

    const requestOptions = React.useMemo(() => {
        return {
            requestName: GET_GLOBAL_SETTINGS,
            requestOptions: {
                queryParams: {},
            },
        };
    }, []);

    const responseHandler = (response) => {
        return (response?.records || [])?.reduce((_p, _c) => {
            _p[_c.name] = _c;

            return _p;
        }, {});
    };

    const [isLoading, response, error, makeResponse] = useRequestHandler(request, requestOptions, responseHandler);

    useEffect(() => {
        makeResponse();

        return () => {
            request.abort();
        };
    }, []);

    return [isLoading, response, error];
};
