import * as React from 'react';

import { deepCopy } from '../utils/utils';

interface IVTDynamicHeightProps {
    defaultItemSize: number;
    itemPadding?: number;
    /* set default itemSize in VL, if you don't use initialState OR your list of items will likely change */
    initialState?: number[];
}

const defaultItemPadding = 10;

export const useVirtualListDynamicHeight = (props: IVTDynamicHeightProps): [number[], (index, ref) => void] => {
    const { defaultItemSize, itemPadding = defaultItemPadding, initialState = [] } = props;
    const [rowHeights, setRowHeights] = React.useState<number[]>(initialState);

    const modifyRowHeights = (rowHeights, index, height) => {
        const newRowHeights: number[] = deepCopy(rowHeights);
        newRowHeights[index] = height + itemPadding;

        return newRowHeights;
    };

    const setRowHeight = (index: number, height: number) => {
        setRowHeights((rowHeights) => modifyRowHeights(rowHeights, index, height));
    };

    const setHeightFromRef = (index, ref) => {
        if (ref?.current?.clientHeight) {
            setRowHeight(index, ref?.current?.clientHeight);
        } else {
            setRowHeight(index, defaultItemSize);
        }
    };

    return [rowHeights, setHeightFromRef];
};
