import { useEffect, useState } from 'react';

export function useWindowResize() {
    const [windowSize, setWindowSize] = useState(() => ({ width: window.innerWidth, height: window.innerHeight }));
    useEffect(() => {
        const onResize = () => setWindowSize({ width: window.innerWidth, height: window.innerHeight });
        window.addEventListener('resize', onResize);

        return () => window.removeEventListener('resize', onResize);
    });

    return windowSize;
}
